/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.kxml2.io.KXmlParser;
import processing.core.PMIDlet;
import processing.xml.XMLElement;

public class XMLParser
implements Runnable {
    public static final int EVENT_TAG_START = 2;
    public static final int EVENT_TEXT = 4;
    public static final int EVENT_TAG_END = 3;
    public static final int EVENT_DOCUMENT_END = 1;
    private PMIDlet midlet;
    private KXmlParser parser;
    private Thread thread;

    public XMLParser(PMIDlet pMIDlet) {
        this.midlet = pMIDlet;
        this.parser = new KXmlParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLElement parse(InputStream inputStream) {
        Object object = this;
        synchronized (object) {
            if (this.thread != null) {
                throw new RuntimeException("Parser is already running");
            }
        }
        try {
            int n;
            this.parser.setInput(new InputStreamReader(inputStream));
            object = null;
            Object object2 = null;
            do {
                n = this.parser.next();
                switch (n) {
                    case 2: {
                        object = new XMLElement(this.parser.getName());
                        int n2 = this.parser.getAttributeCount();
                        for (int i = 0; i < n2; ++i) {
                            ((XMLElement)object).addAttribute(this.parser.getAttributeName(i), this.parser.getAttributeValue(i));
                        }
                        if (object2 != null) {
                            ((XMLElement)object2).addChild((XMLElement)object);
                        }
                        object2 = object;
                        break;
                    }
                    case 3: {
                        object = ((XMLElement)object2).getParent();
                        if (object == null) break;
                        object2 = object;
                        break;
                    }
                    case 4: {
                        object = new XMLElement(this.parser.getText(), true);
                        if (object2 == null) break;
                        ((XMLElement)object2).addChild((XMLElement)object);
                    }
                }
            } while (n != 1);
            return object2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public XMLElement parse(String string) {
        return this.parse(new ByteArrayInputStream(string.getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(InputStream inputStream) {
        XMLParser xMLParser = this;
        synchronized (xMLParser) {
            if (this.thread == null) {
                try {
                    this.parser.setInput(new InputStreamReader(inputStream));
                    this.thread = new Thread(this);
                    this.thread.start();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            } else {
                throw new RuntimeException("Parser is already running");
            }
        }
    }

    public void start(String string) {
        this.start(new ByteArrayInputStream(string.getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        XMLParser xMLParser = this;
        synchronized (xMLParser) {
            this.thread = null;
        }
    }

    public String attribute(String string) {
        if (this.parser != null) {
            return this.parser.getAttributeValue(null, string);
        }
        throw new RuntimeException("Parser not running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.thread == thread) {
            try {
                int n = this.parser.next();
                String string = null;
                switch (n) {
                    case 2: 
                    case 3: {
                        string = this.parser.getName();
                        break;
                    }
                    case 4: {
                        string = this.parser.getText();
                    }
                }
                XMLParser xMLParser = this;
                synchronized (xMLParser) {
                    this.midlet.enqueueLibraryEvent(this, n, string);
                    this.wait();
                }
                if (n == 1) {
                    break;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            Thread.yield();
        }
        XMLParser xMLParser = this;
        synchronized (xMLParser) {
            if (this.thread == thread) {
                this.thread = null;
            }
        }
    }
}

